﻿import mx.transitions.Tween;

/**
 * Extends the MM Tween class so you can add a delay before a tween.
 * 
 * usage:
 * new TweenDelay(box_mc, "_x", Elastic.easeOut, 0, 300, 3, 1, true);
 * 
 * would move box_mc along the x-axis, 300 pixels over the course
 * of 3 seconds with a 1 second delay before starting.
 * 
 * 
 * @author 		Tim Walling
 * @version 	1.0.0
 */

class res.asclass.TweenDelay extends Tween {

	private var _delay:Number;
	private var _intervalDelayID:Number;
	
	/**
	 * Constructor
	 * 
	 * All the usual stuff but with a new delay param.
	 * 
	 * @param 	delay 	Delay (in seconds) before tween begins.
	 */
	public function TweenDelay(obj, prop, func, begin, finish, duration, delay, useSeconds) {
		super(obj, prop, func, begin, finish, duration, useSeconds);
		
		this.delay = delay;
		
		this.delayStart();
	}
	
	private function start():Void {
		// overwritting Tween start method since it gets called by super constructor
	}
	
	private function delayStart():Void {
		if (this.delay > 0) {
			this._intervalDelayID = setInterval(this, "continueStart", this.delay);
		} else {
			this.continueStart();
		}
	}
	
	private function continueStart():Void {
		clearInterval(this._intervalDelayID);
		
		super.start();
	}
	
	
	
	function set delay(d:Number):Void {
		this._delay = (d == null || d <= 0) ? 0 : d*1000;
	}
	
	function get delay():Number {
		return this._delay;
	}
}

